﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<script runat="server">

    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
        }
    
        string urzadPracyW;
        [Required]
        public string UrzadPracyW {
            get { return urzadPracyW; }
            set {
                urzadPracyW = value;
                OnChanged(EventArgs.Empty);
            }
        }

        int iloscKopii = 1;
        [Caption("Ilość kopii")]
        public int IloscKopii {
            get { return iloscKopii; }
            set {
                if (value <= 0)
                    value = 1;
                iloscKopii = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool pelneStanowisko = false;
        [Priority(1)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
    
    void dc_ContextLoad(Object sender, EventArgs e) {
        PracHistoria historia = (PracHistoria)dc[typeof(PracHistoria)];
        ReportHeader1["MIEJSCOWOSC"] = GetMiejscowosc(historia);
                
        typUmowy.EditValue = CaptionAttribute.EnumToString(historia.Etat.TypUmowy).ToLower();
        stanowisko.EditValue = GetStanowisko(historia).ToLower();
        urzadPracy.EditValue = pars.UrzadPracyW;

        Date data = ((ActualDate)dc[typeof(ActualDate)]).Actual;
        ReportHeader1["DATA"] = data.ToString();
        
        ArrayList al = new ArrayList();
        for (int i = 0; i < Pars.IloscKopii; i++)
            al.Add(historia);
        DataRepeater1.DataSource = al;
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srpars.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }

    string GetMiejscowosc(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
        }                
        return miejscowosc;
    }
        
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Tytu wydruku</title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="form" method="post" runat="server">
        <p>
            <ea:datacontext id="dc" runat="server" TypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" OnContextLoad="dc_ContextLoad"></ea:datacontext>
            <ea:DataRepeater ID="DataRepeater1" runat="server" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" Width="100%" Height="161px">
            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" 
				ResetPageCounter="True"></ea:PageBreak>
            <cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Zaświadczenie o zatrudnieniu|%MIEJSCOWOSC%, %DATA%" runat="server"></cc1:ReportHeader>
        </p>
        <font face="Tahoma" size="2">
        <p align="left">
        </p>
        <p align="center">
        </p>
        <p align="center">
        </p>
        <p align="center">
        </p>
        <p align="center">
            <b>Urząd Pracy<br />
            w<br />
            <ea:DataLabel id="urzadPracy" runat="server" Bold="False"></ea:DataLabel>
            </b>
        </p>
        <p align="center">
        </p>
        <p align="center">
        </p>
        <p>
        </p>
        <p>
            Informujemy, że 
            <ea:DataLabel id="DataLabel9" runat="server" Bold="False" DataMember="Plec">
                <ValuesMap>
                    <ea:ValuesPair Key="Kobieta" Value="pani"></ea:ValuesPair>
                    <ea:ValuesPair Key="Mężczyzna" Value="pan"></ea:ValuesPair>
                </ValuesMap>
            </ea:DataLabel>
            &nbsp;<ea:DataLabel id="DataLabel8" runat="server" Bold="False" DataMember="Imie"></ea:DataLabel>
            &nbsp;<ea:DataLabel id="DataLabel5" runat="server" Bold="False" DataMember="Nazwisko"></ea:DataLabel>
            , ur. 
            <ea:DataLabel id="DataLabel6" runat="server" Bold="False" DataMember="Urodzony.Data"></ea:DataLabel>
            &nbsp;r., zam. 
            <ea:DataLabel id="DataLabel7" runat="server" Bold="False" DataMember="Adres.Linia1"></ea:DataLabel>
            , 
            <ea:DataLabel id="DataLabel1" runat="server" Bold="False" DataMember="Adres.Linia2"></ea:DataLabel>
            ,&nbsp; 
            <ea:DataLabel id="DataLabel10" runat="server" Bold="False" DataMember="Plec">
                <ValuesMap>
                    <ea:ValuesPair Key="Kobieta" Value="została zatrudniona"></ea:ValuesPair>
                    <ea:ValuesPair Key="Mężczyzna" Value="został zatrudniony"></ea:ValuesPair>
                </ValuesMap>
            </ea:DataLabel>
            &nbsp;w naszej firmie&nbsp; 
            <ea:DataLabel id="typUmowy" runat="server" Bold="False"></ea:DataLabel>
            &nbsp;dn. 
            <ea:DataLabel id="DataLabel3" runat="server" Bold="False" DataMember="Etat.Okres.From"></ea:DataLabel>
            &nbsp;na stanowisku 
            <ea:DataLabel id="stanowisko" runat="server" Bold="False"></ea:DataLabel>
            w wymiarze:
            <ea:DataLabel id="DataLabel2" runat="server" Bold="False" DataMember="Etat.Wymiar"></ea:DataLabel>. 
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False">
            <Subtitles>
                <cc1:FooterSubtitle SubtitleType="Empty" Width="50"></cc1:FooterSubtitle>
                <cc1:FooterSubtitle Caption="Pieczęć imienna i podpis kierownika zakadu&lt;br&gt;lub osoby przez niego upoważnionej" Width="50"></cc1:FooterSubtitle>
            </Subtitles>
        </cc1:ReportFooter>
		<ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
    </form>
</body>
</html>
